"use client"
import { Search, Camera, ShieldCheck, Loader2 } from "lucide-react";
import { SETTINGS_MAP } from "@/lib/search-data";
import GlobalSearch from "@/components/Search/GlobalSearch";
// import { useAuth } from "@/context/AuthContext"
import { useAuth } from "@/context/AuthContext"
import Link from "next/link";
const API_URL = process.env.NEXT_PUBLIC_API_BASE_URL

export default function DashboardPage() {
  const quickLinks = ["My password", "Devices", "Password Manager", "My Activity", "Email"];
  // const { user, setUser } = useAuth()
  const { user, loading, refreshUser } = useAuth()
  // const user ={
  //   first_name :'Ananda',
  //   primary_email : 'ananda@gmail.com'
  // }

  if (loading) {
    return (
      <div className="h-screen w-full flex items-center justify-center bg-background">
        <div className="flex flex-col items-center gap-4">
          <Loader2 className="h-8 w-8 animate-spin text-sidebar-primary" />
          <p className="text-muted-foreground animate-pulse">Loading your account...</p>
        </div>
      </div>
    );
  }
  return user ? (
    <div className="max-w-4xl mx-auto pt-12 px-6 h-full flex flex-col">
      {/* Profile Section */}
      <div className="flex flex-col items-center text-center mb-10">
        <div className="relative group cursor-pointer">
          <div className="w-24 h-24 rounded-full bg-sidebar-primary flex items-center justify-center text-3xl text-white font-semibold">
            {!user.profile_picture && user.first_name.toUpperCase().charAt(0)}
            {user.profile_picture && <img src={`${API_URL}/media/${user.profile_picture}`} alt="Profile Picture" className="rounded-full" />}
          </div>
          <div className="absolute bottom-0 right-0 bg-background border border-border p-1.5 rounded-full shadow-sm">
            <Link href="/settings">
              <Camera size={16} className="text-muted-foreground" />
            </Link>
          </div>
        </div>
        <h1 className="mt-4 text-3xl font-normal text-foreground">{user?.first_name}</h1>
        <p className="text-muted-foreground text-sm">{user?.primary_email}</p>
      </div>

      {/* Search Bar */}
      <div className="relative mb-8">
        <GlobalSearch
          data={SETTINGS_MAP}
          placeholder="Search settings..."
        /></div>

      {/* <div className="relative max-w-2xl mx-auto mb-8">
        <Search className="absolute left-4 top-1/2 -transform -translate-y-1/2 text-muted-foreground" size={20} />
        <input 
          type="text"
          placeholder="Search Google Account"
          className="w-full pl-12 pr-4 py-3.5 rounded-full border border-border bg-background focus:outline-none focus:ring-2 focus:ring-ring transition-all"
        />
      </div> */}

      {/* Chips */}
      <div className="flex flex-wrap justify-center gap-2 mb-12">
        {quickLinks.map((link) => (
          <button
            key={link}
            className="px-4 py-2 border border-border rounded-lg text-sm font-medium hover:bg-accent transition-colors"
          >
            {link}
          </button>
        ))}
      </div>

      {/* Info Footer */}
      <div className="flex flex-col-reverse items-center gap-3 mt-auto p-4 rounded-xl border border-transparent hover:bg-accent/50 transition-all md:flex-row md:items-start md:space-x-4 md:gap-0">
        {/* Text container */}
        <p className="text-xs text-muted-foreground leading-relaxed text-center md:text-left">
          Only you can see your settings. You might also want to review your settings for Maps,
          Search or whatever Indzs service that you use the most. Google keeps your data private,
    safe and secure. <a href="#" className="text-blue-500 hover:underline">Learn more</a>
        </p>

        {/* Icon container */}
        <div className="text-blue-600 shrink-0">
          <ShieldCheck size={24} />
        </div>
      </div>
    </div>
  ) : null;
}